/*
------------------------------------------------------------------------------
 Scb.h

 KeyChk Secure-Communication-Block (SCB) Structure.
   This memory block is used to pass information to/from the KeyChk DLL.

------------------------------------------------------------------------------
 Please see the manual for a detailed description of each field.
------------------------------------------------------------------------------
*/
#pragma pack( push, 1 )         // Ensure structure has no slack bytes.

typedef struct                  // Version 6+ SCB - 512 bytes total.
{
    WORD            err_code;           // 000 Main Error Code.
    WORD            err_status1;        // 002 Error Status 1.
    WORD            err_status2;        // 004 Error Status 2.
    BYTE            func_code;          // 006 KeyChk Function Code.
    CHAR            scb_id[5];          // 007 SCB Identification:
                                        //     s/b: 0x4B632E3600 ("Kc.6").
    CHAR            prod_id[9];         // 012 Product-ID (Unicode UTF-8).
    BYTE            reserved1;          // 021 Reserved.
    WORD            feature_flags;      // 022 Feature-Flags 1-16:
                                        //     Least Significant Bit = Flag 1.
                                        //     Most Significant Bit = Flag 16.
    DWORD           prod_serial;        // 024 Product Serial Number.
    DWORD           prod_pin;           // 028 Product ID Number (PIN).
    INT16           uses_limit;         // 032 Uses Limit:
                                        //     -1:       Key is Unlimited.
                                        //     0:        Key is Expired.
                                        //     1-32,767: Number of Uses Left.
    WORD            time_limit;         // 034 Time Limit:
                                        //     0xFFFF:   Key is Unlimited.
                                        //     0:        Key is Expired or on
                                        //                 Last Day of operation.
                                        //     1-65,534: Number Days Left.
    CHAR            ed_ascii[9];        // 036 Expire-Date (ED) (ASCIIZ).
                                        //     Always in MM/DD/YY format.
    BYTE            user_data[16];      // 045 User-Data.
                                        //     In v2, last 2 bytes are User-Data Flags.
    BYTE            reserved2[6];       // 061 Reserved.
    BYTE            lasered_id[8];      // 067 Key Lasered-ID (LID).
    BYTE            renew_used_count;   // 075 Renew Used-Count.
    BYTE            reserved3[4];       // 076 Reserved.
    WCHAR           reg_name[32];       // 080 Registration Name (UTF-16 Unicode).
    WCHAR           reg_company[32];    // 144 Registration Company (UTF-16 Unicode).
    WCHAR           reg_other[32];      // 208 Registration Other Info (UTF-16 Unicode).
    WCHAR           expire_date[16];    // 272 Expire-Date (ED) (UTF-16 Unicode).
                                        //     Uses Local Region Settings for format.
    WCHAR           expire_time[16];    // 304 Expire-Time (ET) on last Day (UTF-16 Unicode)
                                        //     Uses Local Region Settings for format.
    BYTE            reserved4[176];     // 336 Reserved.
}SCB;

#pragma pack( pop )             // Resume normal compiler packing.

// End of Source File.
